package data.scripts.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Factions;
import com.fs.starfarer.api.impl.campaign.missions.BaseCampaignMission;
import com.fs.starfarer.api.util.Highlights;
import data.scripts.SWPModPlugin;
import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.campaign.missions.SWP_FamousBountyEvent.FamousBountyStage;
import data.scripts.util.SWP_Util;
import java.util.ArrayList;
import java.util.List;

public class SWP_FamousBountyMission extends BaseCampaignMission {

    private float duration = 60f;
    private FamousBountyStage thisStage;

    public SWP_FamousBountyMission(SectorEntityToken token) {
        event = Global.getSector().getEventManager().primeEvent(new CampaignEventTarget(token), "famous_bounty", null);
        if (event != null && event.isDone()) {
            event = null;
        } else if (event != null) {
            thisStage = ((SWP_FamousBountyEvent) event).getStage();
            SWP_IBBTracker.getTracker().reportStagePosted(thisStage);
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        if (event == null || event.isDone() || !SWP_IBBTracker.getTracker().isStagePosted(thisStage)) {
            event = null;
            Global.getSector().getMissionBoard().removeMission(this, true);
            return;
        }

        duration -= days;
        if (duration < 0f) {
            if (SWP_IBBTracker.getTracker().isStagePosted(thisStage)) {
                ((SWP_FamousBountyEvent) event).endEvent(true);
            }
            Global.getSector().getMissionBoard().removeMission(this, true);
        }
    }

    @Override
    public boolean canPlayerAccept() {
        if (SWPModPlugin.isExerelin) {
            return true;
        }

        FactionAPI playerFaction = Global.getSector().getFaction(Factions.PLAYER);
        RepLevel minStanding = RepLevel.SUSPICIOUS;

        boolean good = false;
        for (String factionId : SWP_FamousBountyEvent.IBB_FACTIONS) {
            FactionAPI faction;
            try {
                faction = Global.getSector().getFaction(factionId);
            } catch (Exception e) {
                continue;
            }
            if (faction != null) {
                good |= playerFaction.isAtWorst(factionId, minStanding);
            }
        }

        return good;
    }

    @Override
    public String getAcceptTooltip() {
        if (canPlayerAccept()) {
            return null;
        }

        FactionAPI playerFaction = Global.getSector().getFaction(Factions.PLAYER);
        RepLevel minStanding = RepLevel.SUSPICIOUS;
        List<String> naughtyFactions = new ArrayList<>(SWP_FamousBountyEvent.IBB_FACTIONS.size());
        for (String factionId : SWP_FamousBountyEvent.IBB_FACTIONS) {
            FactionAPI faction;
            try {
                faction = Global.getSector().getFaction(factionId);
            } catch (Exception e) {
                continue;
            }
            if (faction != null) {
                if (!playerFaction.isAtWorst(factionId, minStanding)) {
                    naughtyFactions.add(faction.getDisplayName());
                }
            }
        }

        String factions = SWP_Util.getOrJoined(naughtyFactions.toArray(new String[naughtyFactions.size()]));
        return "Requires: " + factions + " - " + minStanding.getDisplayName().toLowerCase() + " or better";
    }

    @Override
    public Highlights getAcceptTooltipHighlights() {
        String tooltip = getAcceptTooltip();
        if (tooltip == null) {
            return null;
        }
        Highlights h = new Highlights();

        FactionAPI faction = Global.getSector().getFaction(Factions.INDEPENDENT);
        RepLevel minStanding = RepLevel.SUSPICIOUS;

        h.setText(minStanding.getDisplayName().toLowerCase());
        h.setColors(faction.getRelColor(minStanding));
        return h;
    }

    @Override
    public PersonAPI getImportantPerson() {
        return ((SWP_FamousBountyEvent) event).initPerson(Global.getSector().getFaction("famous_bounty"));
    }

    @Override
    public String getName() {
        PersonAPI person = ((SWP_FamousBountyEvent) event).initPerson(Global.getSector().getFaction("famous_bounty"));
        return "International Bounty Board - " + person.getName().getFullName();
    }

    @Override
    public CampaignEventPlugin getPrimedEvent() {
        return event;
    }

    public FamousBountyStage getStage() {
        if (event == null) {
            return null;
        }
        return ((SWP_FamousBountyEvent) event).getStage();
    }

    @Override
    public void playerAccept(SectorEntityToken entity) {
        super.playerAccept(entity);
        event.setParam(entity.getMarket());
        CampaignEventManagerAPI eventManager = Global.getSector().getEventManager();
        eventManager.startEvent(event);
    }
}
